﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;

namespace RevisionAnalyser
{
    public partial class GlobalVariableForm : Form
    {
        const int MF_BYPOSITION = 0x400;

        [DllImport("User32")]
        private static extern int RemoveMenu(IntPtr hMenu, int nPosition, int wFlags);
        [DllImport("User32")]
        private static extern IntPtr GetSystemMenu(IntPtr hWnd, bool bRevert);
        [DllImport("User32")]
        private static extern int GetMenuItemCount(IntPtr hWnd);

        private string _info;
        private string _name;
        private string _value;
        private bool _nameReadOnly;
        private bool _cancelEnabled;

        public GlobalVariableForm(string info, string name, string value, bool nameReadOnly, bool cancelEnabled)
        {
            _info = info;
            _name = name;
            _value = value;
            _nameReadOnly = nameReadOnly;
            _cancelEnabled = cancelEnabled;
            InitializeComponent();
        }

        private void GlobalVariableForm_Load(object sender, EventArgs e)
        {
            uxInfoLabel.Text = _info;
            uxNameField.Text = _name;
            uxValueField.Text = _value;
            uxNameField.ReadOnly = _nameReadOnly;
            uxCancelButton.Enabled = _cancelEnabled;
            if (_nameReadOnly)
            {
                uxValueField.Select();
            }
            if (!_cancelEnabled)
            {
                IntPtr hMenu = GetSystemMenu(this.Handle, false);
                int menuItemCount = GetMenuItemCount(hMenu);
                RemoveMenu(hMenu, menuItemCount - 1, MF_BYPOSITION);
            }
        }

        public string GetName()
        {
            return uxNameField.Text;
        }

        public string GetValue()
        {
            return uxValueField.Text;
        }

        private void uxOKButton_Click(object sender, EventArgs e)
        {
            if (uxNameField.Text.Trim().Length > 0)
            {
                DialogResult = DialogResult.OK;
                Close();
            }
        }

        private void uxNameField_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (!(Char.IsLetter(e.KeyChar) || Char.IsControl(e.KeyChar) || e.KeyChar == '_'))
            {
                e.Handled = true;
            }
        }
    }
}
